<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Smart360 - Build Your Wealth</title>

  <!-- Manifest for PWA -->
  <link rel="manifest" href="manifest.json">

  <!-- Theme color for status bar -->
  <meta name="theme-color" content="#1ca68f">

  <style>
    @import url('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;600;700;800&display=swap');

    :root{
      --bg1:#1ca68f;
      --bg2:#2aa78d;
      --accent:#1fbf9a;
      --accent-dark:#16826f;
      --card-bg: rgba(255,255,255,0.05);
      --text-light: rgba(255,255,255,0.9);
      --shadow: 0 12px 24px rgba(0,0,0,0.18);
    }

    *{box-sizing:border-box;}
    body{
      margin:0;
      font-family: Inter, system-ui, -apple-system, "Segoe UI", Roboto, "Helvetica Neue", Arial;
      background: linear-gradient(180deg,var(--bg1),var(--bg2));
      color: #fff;
      display: flex;
      flex-direction: column;
      align-items: center;
      justify-content: center;
      padding: 20px;
      min-height: 100vh;
      text-align: center;
    }

    h1 {
      font-size: 28px;
      margin-bottom: 12px;
      color: var(--accent);
    }

    p {
      font-size: 16px;
      line-height: 1.5;
      max-width: 360px;
      margin: 10px auto 20px auto;
      color: #fff;
    }

    #installBtn {
      display: none;
      padding: 14px 24px;
      background: var(--accent);
      color: white;
      border: none;
      border-radius: 12px;
      font-size: 16px;
      cursor: pointer;
      box-shadow: var(--shadow);
      transition: transform 0.2s, background 0.2s;
      margin-bottom: 20px;
    }

    #installBtn:hover {
      background: var(--accent-dark);
      transform: translateY(-2px);
    }

    .features {
      margin-top: 20px;
      text-align: left;
      max-width: 400px;
      background: var(--card-bg);
      padding: 18px;
      border-radius: 16px;
      box-shadow: var(--shadow);
    }

    .feature-item {
      display: flex;
      align-items: center;
      margin-bottom: 12px;
      color: #fff;
    }

    .feature-item i {
      font-size: 20px;
      margin-right: 12px;
      color: var(--accent);
      width: 30px;
      text-align: center;
    }

    footer {
      margin-top: auto;
      padding: 12px;
      font-size: 12px;
      color: #ccc;
    }

  </style>

  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
</head>
<body>
  <h1>Smart360</h1>
  <p>Join thousands of users growing their assets with Smart360. Invest, roll rewards, use referrals, and manage your profile from anywhere.</p>

  <button id="installBtn">Install App</button>

  <div class="features">
    <div class="feature-item"><i class="fas fa-coins"></i>Track your USDT balance and daily earnings</div>
    <div class="feature-item"><i class="fas fa-dice"></i>Roll dice and earn rewards every 24 hours</div>
    <div class="feature-item"><i class="fas fa-wallet"></i>Recharge your account safely and quickly</div>
    <div class="feature-item"><i class="fas fa-users"></i>Invite friends and earn referral bonuses</div>
    <div class="feature-item"><i class="fas fa-user-circle"></i>Manage your profile and investments</div>
    <div class="feature-item"><i class="fas fa-mobile-alt"></i>Access all features conveniently on mobile</div>
  </div>

  <footer>&copy; 2025 Smart360. All rights reserved.</footer>

  <script>
    let deferredPrompt;
    const installBtn = document.getElementById('installBtn');

    // Show install button if beforeinstallprompt event fired
    window.addEventListener('beforeinstallprompt', (e) => {
      e.preventDefault();
      deferredPrompt = e;
      installBtn.style.display = 'inline-block';
    });

    // Handle install button click
    installBtn.addEventListener('click', async () => {
      if (deferredPrompt) {
        deferredPrompt.prompt();
        const { outcome } = await deferredPrompt.userChoice;
        if (outcome === 'accepted') {
          console.log('User accepted the install');
        } else {
          console.log('User dismissed the install');
        }
        deferredPrompt = null;
        installBtn.style.display = 'none';
      }
    });

    // Register service worker
    if ('serviceWorker' in navigator) {
      navigator.serviceWorker.register('service_worker.js')
        .then(() => console.log('Service Worker registered'))
        .catch(err => console.log('Service Worker registration failed:', err));
    }
  </script>
</body>
</html>
