<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Smart360 Tutorials</title>
  <style>
    @import url('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;600;700;800&display=swap');

    :root{
      --bg1:#1ca68f;
      --bg2:#2aa78d;
      --accent:#f2b400;
      --accent-dark:#e0a400;
      --card-bg: rgba(255,255,255,0.05);
      --text-light: rgba(255,255,255,0.9);
      --shadow: 0 12px 24px rgba(0,0,0,0.18);
    }

    *{box-sizing:border-box;}
    body{
      margin:0;
      font-family: Inter, system-ui, -apple-system, "Segoe UI", Roboto, "Helvetica Neue", Arial;
      background: linear-gradient(180deg,var(--bg1),var(--bg2));
      color: #fff;
      display: flex;
      justify-content: center;
      padding: 24px 12px;
    }

    .container{
      width: 390px;
      min-height: 780px;
      background: linear-gradient(180deg, rgba(255,255,255,0.03), rgba(255,255,255,0.01));
      border-radius: 28px;
      padding: 18px 16px 48px;
      box-shadow: 0 18px 40px rgba(5,40,35,0.45);
      overflow-y: auto;
    }

    .topbar{
      display:flex;
      align-items:center;
      justify-content:space-between;
      margin-bottom: 18px;
    }

    .topbar h2{
      font-size: 20px;
      font-weight: 700;
      color: #e9fff9;
    }

    .tutorial-card{
      background: var(--card-bg);
      border-radius: 16px;
      padding: 18px;
      margin-bottom: 14px;
      box-shadow: var(--shadow);
      transition: transform 0.2s ease;
      cursor: pointer;
    }

    .tutorial-card:hover{
      transform: translateY(-3px);
    }

    .tutorial-card h3{
      margin:0 0 8px 0;
      color: var(--accent);
      font-size: 18px;
      font-weight: 700;
    }

    .tutorial-card p{
      margin:0;
      color: var(--text-light);
      font-size: 14px;
      line-height: 1.4;
    }
  </style>
</head>
<body>
  <div class="container">
    <div class="topbar">
      <h2>Tutorials</h2>
    </div>

    <!-- Tutorial Cards -->
    <div class="tutorial-card" onclick="window.location.href='earn.php'">
      <h3>How to Roll Dice</h3>
      <p>Learn how to roll dice and earn USDT rewards every 24 hours. Step-by-step guide for beginners.</p>
    </div>

    <div class="tutorial-card" onclick="window.location.href='invest.php'">
      <h3>Understanding Investments</h3>
      <p>Explore how investments work in Smart360, including calculating daily income and leveling up.</p>
    </div>

    <div class="tutorial-card" onclick="window.location.href='team.php'">
      <h3>Referral System</h3>
      <p>Discover how to invite friends, earn bonuses, and maximize your earnings through referrals.</p>
    </div>

    <div class="tutorial-card" onclick="window.location.href='profile.php'">
      <h3>Profile Management</h3>
      <p>Manage your profile, update personal info, and track your USDT balance efficiently.</p>
    </div>

    <div class="tutorial-card" onclick="window.location.href='home.php'">
      <h3>Leveling Up Challenges</h3>
      <p>Complete daily and novice challenges to level up and increase your USDT rewards.</p>
    </div>
  </div>
</body>
</html>
