<?php
// earn.php
session_start();
require_once "db.php"; // lazima iwe na $conn ya mysqli

// =========================
// Check kama user ame-login
// =========================
if (!isset($_SESSION['user_id'])) {
    die("You must be logged in.");
}
$user_id = $_SESSION['user_id'];

// =========================
// Fetch active investment
// =========================
$investment = null;
$sql = "SELECT * FROM investments 
        WHERE user_id = ? 
        AND status = 'active' 
        ORDER BY created_at DESC 
        LIMIT 1";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$res = $stmt->get_result();
if ($res->num_rows > 0) {
    $investment = $res->fetch_assoc();
}

// =========================
// Handle Roll Dice (AJAX)
// =========================
if (isset($_POST['action']) && $_POST['action'] === 'roll') {
    if (!$investment) {
        echo json_encode(["status" => "error", "msg" => "No active investment"]);
        exit;
    }

    // Ikiwa received_at ni NULL, tumia created_at kwa roll ya kwanza
    $last_receive = $investment['received_at'] ? $investment['received_at'] : $investment['created_at'];

    // Hesabu tofauti kati ya last_receive na sasa (kwa sekunde) kwa kutumia UNIX_TIMESTAMP
    $sql = "SELECT (UNIX_TIMESTAMP(NOW()) - UNIX_TIMESTAMP(?)) as diff";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $last_receive);
    $stmt->execute();
    $diff = $stmt->get_result()->fetch_assoc()['diff'];

    // Ikiwa haijafika masaa 24
    if ($diff < 86400) {
        echo json_encode(["status" => "error", "msg" => "Countdown not finished"]);
        exit;
    }

    $daily_income = floatval($investment['daily_income']);

    // Update user balance
    $conn->query("UPDATE users SET balance = balance + $daily_income WHERE id = $user_id");

    // Mark as received (update received_at na next_receive)
    $stmt = $conn->prepare("UPDATE investments 
                            SET received_at = NOW(), next_receive = DATE_ADD(NOW(), INTERVAL 1 DAY) 
                            WHERE id = ?");
    $stmt->bind_param("i", $investment['id']);
    $stmt->execute();

    // ====== Insert roll record ======
    $stmt = $conn->prepare("INSERT INTO roll_records (user_id, investment_id, reward) VALUES (?,?,?)");
    $stmt->bind_param("iid", $user_id, $investment['id'], $daily_income);
    $stmt->execute();
    // ===============================

    echo json_encode(["status" => "success", "reward" => $daily_income]);
    exit;
}

?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Smart360 - Roll Dice UI (Mock)</title>
  <style>
    /* ====== Fonts ====== */
    @import url('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;600;700;800&display=swap');
    :root{
      --bg1: #1ca68f;
      --bg2: #2aa78d;
      --card: rgba(255,255,255,0.06);
      --card-2: rgba(255,255,255,0.04);
      --accent: #f2b400;
      --accent-dark: #e0a400;
      --muted: rgba(255,255,255,0.85);
      --glass: rgba(255,255,255,0.03);
      --shadow: 0 12px 24px rgba(0,0,0,0.18);
    }
    *{box-sizing:border-box}
    html,body{height:100%}
    body{
      margin:0;
      font-family:Inter, system-ui, -apple-system, "Segoe UI", Roboto, "Helvetica Neue", Arial;
      background: linear-gradient(180deg,var(--bg1), var(--bg2));
      -webkit-font-smoothing:antialiased;
      color:#0b3f3a;
      display:flex;
      align-items:flex-start;
      justify-content:center;
      padding:24px 12px;
    }
    .phone{width:390px;min-height:780px;background:linear-gradient(180deg, rgba(255,255,255,0.03), rgba(255,255,255,0.01));border-radius:28px;padding:18px 16px 98px;box-shadow: 0 18px 40px rgba(5,40,35,0.45);position:relative;overflow:hidden;backdrop-filter: blur(6px);}
    .topbar{display:flex;align-items:center;justify-content:space-between}
    .left-brand{display:flex;align-items:center;gap:12px}
    .app-icon{width:46px;height:46px;border-radius:10px;background:linear-gradient(180deg,#0e6b66,#0c524f);display:flex;align-items:center;justify-content:center;box-shadow:0 6px 12px rgba(0,0,0,0.25)}
    .app-icon svg{width:26px;height:26px}
    .brand-text{font-weight:700;color:#e9fff9}
    .top-right{display:flex;align-items:center;gap:10px}
    .status-pill{background:rgba(255,255,255,0.04);padding:8px 14px;border-radius:28px;display:flex;gap:14px;align-items:center;box-shadow:inset 0 -3px rgba(0,0,0,0.08)}
    .status-item{display:flex;align-items:center;gap:8px;color:#dff6ef;font-size:13px}
    .dot{width:10px;height:10px;border-radius:50%;background:#13d045;box-shadow:0 0 8px rgba(19,208,69,0.4)}
    .gear{width:36px;height:36px;border-radius:999px;background:rgba(255,255,255,0.04);display:flex;align-items:center;justify-content:center}
    .content{margin-top:18px;padding-bottom:120px;}
    .balance-card{background:linear-gradient(180deg, rgba(255,255,255,0.03), rgba(255,255,255,0.02));padding:22px;border-radius:16px;display:flex;align-items:center;gap:18px;box-shadow:var(--shadow)}
    .token{width:56px;height:56px;border-radius:12px;background:rgba(255,255,255,0.06);display:flex;align-items:center;justify-content:center}
    .token svg{width:28px;height:28px}
    .balance-value{font-weight:800;font-size:34px;color:#eafffb}
    .subpill{margin-top:12px;background:rgba(255,255,255,0.03);padding:12px;border-radius:999px;color:#ddf8ef;text-align:center}
    .dice-card{margin-top:18px;background:linear-gradient(180deg, rgba(255,255,255,0.03), rgba(255,255,255,0.02));padding:22px;border-radius:18px;box-shadow:0 10px 30px rgba(2,28,26,0.35)}
    .dice-title{font-weight:700;color:var(--accent);font-size:22px;text-align:center;margin-bottom:18px}
    .dice-face{width:140px;height:140px;background:#fff;border-radius:18px;margin:0 auto;display:flex;align-items:center;justify-content:center;box-shadow:0 8px 18px rgba(2,28,26,0.12)}
    .dot-face{width:18px;height:18px;background:var(--bg2);border-radius:50%}
    .btn-roll{display:block;margin:18px auto 0;padding:18px 26px;border-radius:14px;background:linear-gradient(180deg,var(--accent),var(--accent-dark));color:#0b2b22;font-weight:800;border:none;font-size:18px;cursor:pointer;box-shadow:0 10px 18px rgba(0,0,0,0.15);width:80%;}
    .how{margin-top:22px;background:linear-gradient(180deg, rgba(255,255,255,0.025), rgba(255,255,255,0.02));padding:18px;border-radius:16px}
    .how h3{color:var(--accent);margin:0 0 8px 0;text-align:center}
    .popup{position:fixed;top:0;left:0;width:100%;height:100%;background:transparent;display:flex;align-items:center;justify-content:center;visibility:hidden;opacity:0;transition:opacity .3s;}
    .popup.active{visibility:visible;opacity:1;}
    .popup-box{background:#fff;padding:24px 28px;border-radius:16px;text-align:center;max-width:320px}
    .popup-box h2{margin:0 0 12px;color:#0b2b22}
    .popup-box button{margin-top:14px;padding:10px 18px;border:none;border-radius:10px;background:var(--accent);font-weight:700;cursor:pointer}
     /* bottom nav */
    .bottom-nav{
      position:fixed;left:50%;transform:translateX(-50%);
      bottom:12px;width:calc(100% - 36px);max-width:366px;
      background:linear-gradient(180deg,rgba(0,0,0,0.02),rgba(0,0,0,0.03));
      backdrop-filter:blur(6px);
      border-radius:14px;padding:10px 12px;
      display:flex;align-items:center;justify-content:space-around;
    }
    .nav-item{flex:1;display:flex;flex-direction:column;align-items:center;padding:8px 6px;border-radius:10px;color:#dffaf4;font-size:13px;cursor:pointer}
    .nav-item .icon{width:44px;height:44px;border-radius:10px;display:flex;align-items:center;justify-content:center;background:rgba(255,255,255,0.02)}
    .nav-item.active{background:linear-gradient(180deg,rgba(0,0,0,0.07),rgba(0,0,0,0.03))}
    .nav-item svg{width:22px;height:22px;fill:#dffaf4}
    .nav-item.active svg{fill:var(--accent)}
  </style>
</head>
<body>
  <div class="phone" role="application">
    <div class="topbar">
      <div class="left-brand">
        <div class="app-icon" aria-hidden>
          <svg viewBox="0 0 24 24" fill="none">
            <path d="M12 2 L8 9 L12 22 L16 9 Z" fill="#7fe6df"/>
            <path d="M12 2 L4 9 L12 22 L20 9 Z" opacity="0.15" fill="#0b6b60"/>
          </svg>
        </div>
        <div class="brand-text">Smart360</div>
      </div>
      <div class="top-right">
        <div class="status-pill">
          <div class="status-item"><span class="dot"></span><span>Sync</span></div>
          <div style="width:1px;height:30px;background:rgba(255,255,255,0.03);border-radius:2px"></div>
          <div class="status-item"><span style="background:linear-gradient(180deg,#e6fff5,#d0fff0);padding:6px;border-radius:999px">T</span><span>+0</span></div>
       </div>
<div class="gear" title="Settings" onclick="window.location.href='records.php'">⚙</div>
</div>
    </div>

    <div class="content">
      <div class="balance-card">
        <div class="token">
          <svg viewBox="0 0 24 24" fill="none"><circle cx="12" cy="12" r="9" fill="#ebfffb" opacity="0.06"/><path d="M10.6 8h2.8c1.1 0 1.1 1.2 1.1 1.2s0 1.3-1.1 1.3H12v3h-1.4v-3h-1.1s-1.1-.1-1.1-1.3S9.5 8 10.6 8z" fill="#eafffb"/></svg>
        </div>
        <div>
          <div class="balance-value">
            <?php
              $bal = $conn->query("SELECT balance FROM users WHERE id=$user_id")->fetch_assoc();
              echo number_format($bal['balance'],2)." USDT";
            ?>
          </div>
          <div style="height:8px"></div>
          <div class="subpill">
            <?php if($investment){ echo "USDT Novice • 1 / 9"; } else { echo "No Active Investment"; } ?>
          </div>
        </div>
      </div>

      <div class="dice-card">
        <div class="dice-title">Roll Dice to Earn USDT</div>
        <div class="dice-face" id="diceFace" aria-hidden>
          <div class="dot-face" id="diceDot"></div>
        </div>
        <button class="btn-roll" id="rollBtn" <?php if(!$investment) echo "disabled"; ?>>Roll Dice</button>
        <?php if($investment){ 
            $last_receive = $investment['received_at'] ? $investment['received_at'] : $investment['created_at'];
            $q = $conn->query("SELECT (UNIX_TIMESTAMP(NOW()) - UNIX_TIMESTAMP('$last_receive')) as diff")->fetch_assoc();
            $remain = max(0, 86400 - $q['diff']);
        ?>
        <div id="countdown" style="text-align:center;margin-top:12px;color:#fff;font-size:14px;"></div>
        <script>var remain=<?=$remain?>;</script>
        <?php } ?>
      </div>

      <div class="how">
        <h3>How to Play</h3>
        <p style="color:rgba(255,255,255,0.9);opacity:0.9;text-align:center;margin:8px 12px 0;font-size:14px;">Tap <strong>Roll Dice</strong> to spin the dice. Win USDT rewards based on the roll. Complete the novice challenge to level up.</p>
      </div>
    </div>
  </div>

  <div class="popup" id="popup">
    <div class="popup-box">
      <h2>Reward Earned!</h2>
      <p id="rewardText"></p>
      <button onclick="closePopup()">OK</button>
    </div>
  </div>
  
   <!-- Bottom Navigation -->
  <div class="bottom-nav">
    <div class="nav-item" onclick="location.href='home.php'">
      <div class="icon">
        <svg viewBox="0 0 24 24"><path d="M3 10L12 3l9 7v11a1 1 0 0 1-1 1h-6v-7h-4v7H4a1 1 0 0 1-1-1V10z"/></svg>
      </div>
      <div style="margin-top:6px">Home</div>
    </div>
    <div class="nav-item  active" onclick="location.href='earn.php'">
      <div class="icon"><div style="width:24px;height:24px;background:linear-gradient(180deg,#1fbf9a,#16826f);border-radius:50%;display:flex;align-items:center;justify-content:center;font-weight:700;color:#fff">T</div></div>
      <div style="margin-top:6px">Earn</div>
    </div>
    <div class="nav-item" onclick="location.href='invest.php'">
      <div class="icon">
        <svg viewBox="0 0 24 24"><path d="M12 2C8.13 2 5 5.13 5 9c0 5.25 7 13 7 13s7-7.75 7-13c0-3.87-3.13-7-7-7z"/></svg>
      </div>
       <div style="margin-top:6px">Invest</div>
    </div>
    <div class="nav-item" onclick="location.href='team.php'">
      <div class="icon">
        <svg viewBox="0 0 24 24"><path d="M16 11c1.66 0 2.99-1.34 2.99-3S17.66 5 16 5s-3 1.34-3 3 1.34 3 3 3zM8 11c1.66 0 2.99-1.34 2.99-3S9.66 5 8 5 5 6.34 5 8s1.34 3 3 3zm0 2c-2.33 0-7 1.17-7 3.5V19h14v-2.5C15 14.17 10.33 13 8 13zm8 0c-.29 0-.62.02-.97.05 1.16.84 1.97 1.97 1.97 3.45V19h6v-2.5c0-2.33-4.67-3.5-7-3.5z"/></svg>
      </div>
 <div style="margin-top:6px">Team</div>
    </div>
    <div class="nav-item" onclick="location.href='profile.php'">
      <div class="icon">
        <svg viewBox="0 0 24 24"><path d="M12 12c2.7 0 5-2.3 5-5s-2.3-5-5-5-5 2.3-5 5 2.3 5 5 5zm0 2c-3.3 0-10 1.7-10 5v3h20v-3c0-3.3-6.7-5-10-5z"/></svg>
      </div>
      <div style="margin-top:6px">Profile</div>
    </div>
  </div>
  <script>
    const rollBtn = document.getElementById('rollBtn');
    const diceFace = document.getElementById('diceFace');
    const diceDot = document.getElementById('diceDot');
    const popup = document.getElementById('popup');
    const rewardText = document.getElementById('rewardText');

    function showFace(n){
      diceDot.style.transform = 'scale(' + (0.6 + n*0.05) + ')';
      diceDot.style.transition = 'transform 450ms cubic-bezier(.2,.9,.3,1)';
    }

    function closePopup(){
      popup.classList.remove('active');
      location.reload();
    }

    if(typeof remain !== "undefined"){
      const cd = document.getElementById('countdown');
      function tick(){
        if(remain <= 0){
          cd.innerText = "You can roll now!";
          rollBtn.disabled = false;
          return;
        }
        let h=Math.floor(remain/3600), m=Math.floor((remain%3600)/60), s=remain%60;
        cd.innerText = "Next roll in "+h+"h "+m+"m "+s+"s";
        remain--;
        setTimeout(tick,1000);
      }
      tick();
    }

    rollBtn.addEventListener('click', () => {
      rollBtn.disabled = true;
      rollBtn.textContent = 'Rolling...';
      diceFace.animate([
        { transform: 'rotate(0deg)' },
        { transform: 'rotate(15deg)' },
        { transform: 'rotate(-12deg)' },
        { transform: 'rotate(8deg)' },
        { transform: 'rotate(0deg)' }
      ], { duration: 900, easing: 'ease-in-out' });

      const n = Math.floor(Math.random()*6) + 1;
      setTimeout(()=>{
        showFace(n);

        // Ajax request
        fetch('earn.php', {
          method:'POST',
          headers:{'Content-Type':'application/x-www-form-urlencoded'},
          body:'action=roll'
        }).then(r=>r.json()).then(d=>{
          if(d.status==="success"){
            rewardText.innerText = "You earned "+d.reward+" USDT";
            popup.classList.add('active');
          } else {
            alert(d.msg);
            location.reload();
          }
        });

        rollBtn.textContent = 'Roll Dice';
      }, 900);
    });
  </script>
</body>
</html>
