<!doctype html>
<html lang="en">
<head>
    <link rel="manifest" href="/xml/manifest.json">
  <meta name="theme-color" content="#0ea5a4">
  <link rel="icon" href="/xml/icons/icon-192.png">
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
  <title>FCB - Home</title>
  <style>
    @import url('https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap');
    :root{
      --bg1:#1ca68f;
      --bg2:#2aa78d;
      --accent:#1fbf9a;
      --accent-dark:#16826f;
      --red:#ff4d4d;
      --green:#4dff88;
    }
    *{margin:0;padding:0;box-sizing:border-box}
    body{
      font-family:Inter,system-ui;
      background:linear-gradient(180deg,var(--bg1),var(--bg2));
      display:flex;justify-content:center;
      padding:20px 10px 100px;
      color:#fff;
    }
    .phone{
      width:390px;min-height:780px;
      background:rgba(255,255,255,0.02);
      border-radius:28px;
      padding:14px 14px 100px;
      box-shadow:0 18px 40px rgba(5,40,35,0.45);
      position:relative;
    }
    h1{text-align:center;font-size:22px;margin:10px 0;font-weight:700}

    /* Slideshow */
    .slideshow {
      width:100%;
      height:180px;
      border-radius:16px;
      margin-bottom:12px;
      position:relative;
      overflow:hidden;
    }
    .slide {
      position:absolute;
      top:0;left:0;
      width:100%;height:100%;
      opacity:0;
      transition:opacity 1s ease;
    }
    .slide.active {
      opacity:1;
      z-index:1;
    }
    .slide img {
      width:100%;
      height:100%;
      object-fit:cover;
      border-radius:16px;
    }

    /* Notice marquee */
    .notice{
      background:rgba(0,0,0,0.25);
      padding:8px 0;
      border-radius:12px;
      margin-bottom:16px;
      overflow:hidden;
    }
    .notice marquee{font-weight:600;color:#fff}

    /* Menu Grid */
    .menu-grid{
      display:grid;
      grid-template-columns:repeat(4,1fr);
      gap:12px;
      margin-bottom:16px;
      text-align:center;
    }
    .menu-btn{
      display:flex;
      flex-direction:column;
      align-items:center;
      cursor:pointer;
    }
    .menu-btn .icon-box{
      background:rgba(0,0,0,0.25);
      border-radius:12px;
      width:60px;height:60px;
      display:flex;align-items:center;justify-content:center;
    }
    .menu-btn svg{
      width:28px;height:28px;fill:#fff;
    }
    .menu-btn span{
      margin-top:6px;
      font-size:14px;font-weight:600;
    }
    .menu-btn:hover .icon-box{background:rgba(0,0,0,0.4)}

    /* Congrats Marquee (endless vertical scroll) */
    .congrats{
      background:rgba(0,0,0,0.25);
      border-radius:12px;
      height:100px;
      overflow:hidden;
      margin-bottom:18px;
      padding:10px;
      position:relative;
    }
    .congrats .inner{
      display:flex;
      flex-direction:column;
      animation:scrollUp 12s linear infinite;
    }
    .congrats-item{
      background:rgba(255,255,255,0.08);
      border-radius:8px;
      padding:6px 10px;
      margin:4px 0;
      font-size:14px;
      font-weight:500;
    }
    @keyframes scrollUp{
      0%{transform:translateY(0)}
      100%{transform:translateY(-50%)}
    }

    /* Market */
    .market{margin-top:14px;}
    .market h2{font-size:16px;font-weight:700;margin-bottom:10px}
    .market-grid{
      display:grid;
      grid-template-columns:1fr 1fr;
      gap:12px;
    }
    .coin{
      background:rgba(0,0,0,0.25);
      border-radius:12px;
      padding:12px;
    }
    .coin h3{font-size:14px;font-weight:600;margin-bottom:6px}
    .coin .price{font-size:15px;font-weight:700;color:var(--accent)}
    .coin .change{font-size:13px;font-weight:600;margin-top:4px}

    /* bottom nav */
    .bottom-nav{
      position:fixed;left:50%;transform:translateX(-50%);
      bottom:12px;width:calc(100% - 36px);max-width:366px;
      background:linear-gradient(180deg,rgba(0,0,0,0.02),rgba(0,0,0,0.03));
      backdrop-filter:blur(6px);
      border-radius:14px;padding:10px 12px;
      display:flex;align-items:center;justify-content:space-around;
    }
    .nav-item{flex:1;display:flex;flex-direction:column;align-items:center;padding:8px 6px;border-radius:10px;color:#dffaf4;font-size:13px;cursor:pointer}
    .nav-item .icon{width:44px;height:44px;border-radius:10px;display:flex;align-items:center;justify-content:center;background:rgba(255,255,255,0.02)}
    .nav-item.active{background:linear-gradient(180deg,rgba(0,0,0,0.07),rgba(0,0,0,0.03))}
    .nav-item svg{width:22px;height:22px;fill:#dffaf4}
    .nav-item.active svg{fill:var(--accent)}
  </style>
</head>
<body>
  <div class="phone">
    <h1>Smart360</h1>

    <!-- Slideshow -->
    <div class="slideshow" id="slideshow">
      <div class="slide active"><img src="smart1.jpg"></div>
      <div class="slide"><img src="smart2.jpg"></div>
      <div class="slide"><img src="smart3.jpg"></div>
      <div class="slide"><img src="smart4.jpg"></div>
      <div class="slide"><img src="smart5.jpg"></div>
    </div>

    <!-- Notice -->
    <div class="notice">
     <marquee>
Welcome to Smart360 - Your trusted investment platform! Smart360 is committed to helping you grow your wealth, providing reliable investment opportunities, and ensuring that your financial goals are met with transparency and trust. Our platform is designed to cater to both new and experienced investors, offering a seamless experience that combines technology and expertise. Welcome to Smart360 - Your trusted investment platform! Join thousands of satisfied users who are already taking advantage of our secure investment options, personalized support, and innovative tools to maximize their returns. Smart360 prioritizes your success, your growth, and your peace of mind. Invest wisely, invest confidently, and watch your financial future flourish. Welcome to Smart360 - Your trusted investment platform! Explore our range of investment plans, track your progress, earn bonuses, and be part of a community that values your financial journey. Every step you take with Smart360 is a step towards a brighter, more secure financial future. Welcome to Smart360 - Your trusted investment platform! Smart360 ensures transparency, security, and efficiency in every transaction, helping you achieve your goals faster and smarter. Your trust is our foundation, and your growth is our mission. Join Smart360 today and start your journey towards financial independence with confidence, clarity, and consistent returns.
</marquee>

    </div>

   <!-- Menu Grid -->
<div class="menu-grid">
  <div class="menu-btn" onclick="location.href='#'">
    <div class="icon-box"><i class="fas fa-gift"></i></div>
    <span>Check-in</span>
  </div>
  <div class="menu-btn" onclick="location.href='recharge_usdt.php'">
    <div class="icon-box"><i class="fas fa-wallet"></i></div>
    <span>Recharge</span>
  </div>
  <div class="menu-btn" onclick="location.href='withdraw.php'">
    <div class="icon-box"><i class="fas fa-hand-holding-usd"></i></div>
    <span>Withdraw</span>
  </div>
  <div class="menu-btn" onclick="location.href='app.php'">
    <div class="icon-box"><i class="fas fa-mobile-alt"></i></div>
    <span>App</span>
</div>
</div>


    <!-- Congratulations -->
    <div class="congrats">
      <div class="inner">
        <div class="congrats-item">Congratulations John received 50 USDT</div>
        <div class="congrats-item">Congratulations Mary received 120 USDT</div>
        <div class="congrats-item">Congratulations Peter received 75 USDT</div>
        <div class="congrats-item">Congratulations Ann received 20 USDT</div>
        <div class="congrats-item">Congratulations David received 90 USDT</div>
        <!-- duplicate again for endless effect -->
        <div class="congrats-item">Congratulations John received 50 USDT</div>
        <div class="congrats-item">Congratulations Mary received 120 USDT</div>
        <div class="congrats-item">Congratulations Peter received 75 USDT</div>
        <div class="congrats-item">Congratulations Ann received 20 USDT</div>
        <div class="congrats-item">Congratulations David received 90 USDT</div>
      </div>
    </div>

    <!-- Market -->
    <div class="market">
      <h2>Live Market</h2>
      <div class="market-grid" id="marketGrid"></div>
    </div>
  </div>

  <!-- Bottom Navigation -->
  <div class="bottom-nav">
    <div class="nav-item active" onclick="location.href='home.php'">
      <div class="icon"><svg viewBox="0 0 24 24"><path d="M3 10L12 3l9 7v11a1 1 0 0 1-1 1h-6v-7h-4v7H4a1 1 0 0 1-1-1V10z"/></svg></div>
      <div style="margin-top:6px">Home</div>
    </div>
    <div class="nav-item" onclick="location.href='earn.php'">
      <div class="icon"><div style="width:24px;height:24px;background:linear-gradient(180deg,#1fbf9a,#16826f);border-radius:50%;display:flex;align-items:center;justify-content:center;font-weight:700;color:#fff">T</div></div>
      <div style="margin-top:6px">Earn</div>
    </div>
    <div class="nav-item" onclick="location.href='invest.php'">
      <div class="icon"><svg viewBox="0 0 24 24"><path d="M12 2C8.13 2 5 5.13 5 9c0 5.25 7 13 7 13s7-7.75 7-13c0-3.87-3.13-7-7-7z"/></svg></div>
      <div style="margin-top:6px">Invest</div>
    </div>
    <div class="nav-item" onclick="location.href='team.php'">
      <div class="icon"><svg viewBox="0 0 24 24"><path d="M16 11c1.66 0 2.99-1.34 2.99-3S17.66 5 16 5s-3 1.34-3 3 1.34 3 3 3zM8 11c1.66 0 2.99-1.34 2.99-3S9.66 5 8 5 5 6.34 5 8s1.34 3 3 3zm0 2c-2.33 0-7 1.17-7 3.5V19h14v-2.5C15 14.17 10.33 13 8 13zm8 0c-.29 0-.62.02-.97.05 1.16.84 1.97 1.97 1.97 3.45V19h6v-2.5c0-2.33-4.67-3.5-7-3.5z"/></svg></div>
      <div style="margin-top:6px">Team</div>
    </div>
    <div class="nav-item" onclick="location.href='profile.php'">
      <div class="icon"><svg viewBox="0 0 24 24"><path d="M12 12c2.7 0 5-2.3 5-5s-2.3-5-5-5-5 2.3-5 5 2.3 5 5 5zm0 2c-3.3 0-10 1.7-10 5v3h20v-3c0-3.3-6.7-5-10-5z"/></svg></div>
      <div style="margin-top:6px">Profile</div>
    </div>
  </div>

  <!-- Scripts -->
  <script>
    // Slideshow auto + manual swipe
    const slides = document.querySelectorAll(".slide");
    let current = 0;
    let slideInterval = setInterval(nextSlide, 4000);

    function nextSlide(){
      slides[current].classList.remove("active");
      current = (current+1)%slides.length;
      slides[current].classList.add("active");
    }
    function prevSlide(){
      slides[current].classList.remove("active");
      current = (current-1+slides.length)%slides.length;
      slides[current].classList.add("active");
    }
    let startX = 0;
    document.getElementById("slideshow").addEventListener("touchstart", e=>{
      clearInterval(slideInterval);
      startX = e.touches[0].clientX;
    });
    document.getElementById("slideshow").addEventListener("touchend", e=>{
      let endX = e.changedTouches[0].clientX;
      if(endX < startX - 50) nextSlide();
      if(endX > startX + 50) prevSlide();
      slideInterval = setInterval(nextSlide, 4000);
    });

    // Market loader
    async function loadMarket(){
      try{
        let res = await fetch("https://api.coingecko.com/api/v3/coins/markets?vs_currency=usd&ids=bitcoin,ethereum,binancecoin,tether,tron,cardano,solana,polkadot,litecoin,ripple");
        let data = await res.json();
        let grid = document.getElementById("marketGrid");
        grid.innerHTML="";
        data.forEach(coin=>{
          let change = coin.price_change_percentage_24h?.toFixed(2);
          let changeColor = change >= 0 ? 'var(--green)' : 'var(--red)';
          grid.innerHTML += `
            <div class="coin">
              <h3>${coin.name}</h3>
              <div class="price">$${coin.current_price}</div>
              <div class="change" style="color:${changeColor}">${change}%</div>
            </div>
          `;
        })
      }catch(e){console.log(e)}
    }
    loadMarket();
    setInterval(loadMarket, 30000);
  </script>
    <script>
if ("serviceWorker" in navigator) {
  navigator.serviceWorker.register("service-worker.js")
  .then(reg => console.log("Service Worker registered:", reg))
  .catch(err => console.log("Service Worker failed:", err));
}
</script>
</body>
</html>
