<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
session_start();
require_once "db.php";
date_default_timezone_set("Africa/Nairobi");

// Hakikisha user ame-login
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

$user_id = $_SESSION['user_id'];

// === Define plans A1–A8 ===
$plans = [
    "A1" => ["amount" => 5.00, "daily_income" => 0.25, "daily_percentage" => 5, "valid_time" => 35],
    "A2" => ["amount" => 20.00, "daily_income" => 1.20, "daily_percentage" => 6, "valid_time" => 37],
    "A3" => ["amount" => 40.00, "daily_income" => 2.80, "daily_percentage" => 7, "valid_time" => 40],
    "A4" => ["amount" => 70.00, "daily_income" => 5.60, "daily_percentage" => 8, "valid_time" => 45],
    "A5" => ["amount" => 110.00, "daily_income" => 9.90, "daily_percentage" => 9, "valid_time" => 55],
    "A6" => ["amount" => 230.00, "daily_income" => 25.30, "daily_percentage" => 11, "valid_time" => 64],
    "A7" => ["amount" => 500.00, "daily_income" => 70.00, "daily_percentage" => 14, "valid_time" => 75],
    "A8" => ["amount" => 1000.00, "daily_income" => 180.00, "daily_percentage" => 18, "valid_time" => 100],
];

// === Handle investment submission ===
$message = "";
if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST['plan'])) {
    $plan_id = $_POST['plan'];

    if (isset($plans[$plan_id])) {
        $plan = $plans[$plan_id];

        // Fetch user balance & referral info
        $stmt = $conn->prepare("SELECT balance, referred_by FROM users WHERE id=?");
        $stmt->bind_param("i", $user_id);
        $stmt->execute();
        $stmt->bind_result($balance, $referred_by);
        $stmt->fetch();
        $stmt->close();

        if ($balance >= $plan['amount']) {
            // Deduct balance
            $new_balance = $balance - $plan['amount'];
            $stmt = $conn->prepare("UPDATE users SET balance=? WHERE id=?");
            $stmt->bind_param("di", $new_balance, $user_id);
            $stmt->execute();
            $stmt->close();

            // Insert into investments table
            $created_at = date("Y-m-d H:i:s", strtotime("-3 hours"));
            $received_at = $created_at;
            $end_date = date("Y-m-d H:i:s", strtotime("+{$plan['valid_time']} days", strtotime($created_at)));

            $stmt = $conn->prepare("
                INSERT INTO investments 
                (user_id, product_id, amount, daily_income, daily_percentage, valid_time, created_at, received_at, end_date) 
                VALUES (?,?,?,?,?,?,?,?,?)
            ");
            $stmt->bind_param(
                "isddidsss",
                $user_id,
                $plan_id,
                $plan['amount'],
                $plan['daily_income'],
                $plan['daily_percentage'],
                $plan['valid_time'],
                $created_at,
                $received_at,
                $end_date
            );
            $stmt->execute();
            $stmt->close();

            // ===== Referral Bonuses =====
            $levels = [1 => 0.10, 2 => 0.02, 3 => 0.01]; // 10%, 2%, 1%
            $current_ref = $referred_by;
            $level = 1;

            while ($current_ref && $level <= 3) {
                // Get upline balance & next referral
                $stmt = $conn->prepare("SELECT balance, referred_by FROM users WHERE id=?");
                $stmt->bind_param("i", $current_ref);
                $stmt->execute();
                $stmt->bind_result($upline_balance, $next_ref);
                if ($stmt->fetch()) {
                    $stmt->close();

                    $bonus = $plan['amount'] * $levels[$level];
                    $new_upline_balance = $upline_balance + $bonus;

                    // Update upline balance
                    $stmt2 = $conn->prepare("UPDATE users SET balance=? WHERE id=?");
                    $stmt2->bind_param("di", $new_upline_balance, $current_ref);
                    $stmt2->execute();
                    $stmt2->close();

                    // Insert into referral_bonuses table
                    $created_at_bonus = date("Y-m-d H:i:s");
                    $stmt3 = $conn->prepare("
                        INSERT INTO referral_bonuses (from_user_id, to_user_id, level, amount, created_at)
                        VALUES (?,?,?,?,?)
                    ");
                    $stmt3->bind_param("iiids", $user_id, $current_ref, $level, $bonus, $created_at_bonus);
                    $stmt3->execute();
                    $stmt3->close();

                    // Move to next level
                    $current_ref = $next_ref;
                    $level++;
                } else {
                    $stmt->close();
                    break;
                }
            }

            $message = "✅ Successfully invested in $plan_id. Bonuses distributed & recorded.";
        } else {
            $message = "⚠ Insufficient balance for $plan_id.";
        }
    }
}
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>FCB - Invest Plans</title>
  <style>
    @import url('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;600;700;800&display=swap');
    :root{
      --bg1:#1ca68f;
      --bg2:#2aa78d;
      --accent:#1fbf9a;
      --accent-dark:#16826f;
      --card-bg:rgba(255,255,255,0.04);
    }
    *{box-sizing:border-box;margin:0;padding:0}
    body{
      font-family:Inter,system-ui;
      background:linear-gradient(180deg,var(--bg1),var(--bg2));
      display:flex;justify-content:center;
      padding:24px 12px;
      color:#fff;
    }
    .phone{width:390px;min-height:780px;background:rgba(255,255,255,0.02);border-radius:28px;padding:18px 16px 98px;box-shadow:0 18px 40px rgba(5,40,35,0.45);position:relative;}
    .countdown{text-align:center;font-weight:600;font-size:16px;margin-bottom:18px}
    .plans{display:flex;flex-direction:column;gap:20px}
    .plan{border:1.5px solid var(--accent);border-radius:16px;padding:16px;background:rgba(0,0,0,0.25);}
    .plan h2{text-align:center;font-size:20px;margin-bottom:10px}
    .plan hr{border:none;border-top:1px dashed rgba(255,255,255,0.25);margin:8px 0 14px}
    .plan-details{background:#000;padding:14px;border-radius:12px;display:grid;grid-template-columns:1fr auto;gap:10px;font-size:14px;}
    .plan-details div{color:#ddd}
    .plan-details span{color:var(--accent);font-weight:700}
    .plan-action{margin-top:14px;text-align:center;}
    .plan-action button{width:100%;border:none;border-radius:12px;padding:12px;font-size:15px;font-weight:700;cursor:pointer;color:#fff;background:linear-gradient(180deg,var(--accent),var(--accent-dark));}
    .plan-action .muted-btn{background:transparent;border:1.5px solid var(--accent);color:var(--accent);}
    .bottom-nav{position:fixed;left:50%;transform:translateX(-50%);bottom:12px;width:calc(100% - 36px);max-width:366px;background:linear-gradient(180deg,rgba(0,0,0,0.02),rgba(0,0,0,0.03));backdrop-filter:blur(6px);border-radius:14px;padding:10px 12px;display:flex;align-items:center;justify-content:space-around;}
    .nav-item{flex:1;display:flex;flex-direction:column;align-items:center;padding:8px 6px;border-radius:10px;color:#dffaf4;font-size:13px;cursor:pointer}
    .nav-item .icon{width:44px;height:44px;border-radius:10px;display:flex;align-items:center;justify-content:center;background:rgba(255,255,255,0.02)}
    .nav-item.active{background:linear-gradient(180deg,rgba(0,0,0,0.07),rgba(0,0,0,0.03))}
    .nav-item svg{width:22px;height:22px;fill:#dffaf4}
    .nav-item.active svg{fill:var(--accent)}
    .message{text-align:center;margin:10px 0;color:yellow;font-weight:600;}
  </style>
</head>
<body>
  <div class="phone">
    <?php if($message): ?>
      <div class="message"><?= htmlspecialchars($message) ?></div>
    <?php endif; ?>

    <div class="countdown">
      24:00:00<br>
      <small>Reset Countdown</small>
    </div>

    <div class="plans">
      <?php foreach ($plans as $pid => $p): ?>
        <div class="plan">
          <h2><?= $pid ?></h2>
          <hr>
          <div class="plan-details">
            <div>Daily Percentage</div><span><?= $p['daily_percentage'] ?>%</span>
            <div>Valid Time</div><span><?= $p['valid_time'] ?> Days</span>
            <div>Daily Income</div><span><?= $p['daily_income'] ?> USDT</span>
          </div>
          <div class="plan-action">
            <form method="post">
              <input type="hidden" name="plan" value="<?= $pid ?>">
              <button type="submit"><?= number_format($p['amount'],2) ?> USDT Unlock Now</button>
            </form>
          </div>
        </div>
      <?php endforeach; ?>
    </div>
  </div>

  <!-- Bottom Navigation -->
  <div class="bottom-nav">
    <div class="nav-item" onclick="location.href='home.php'">
      <div class="icon"><svg viewBox="0 0 24 24"><path d="M3 10L12 3l9 7v11a1 1 0 0 1-1 1h-6v-7h-4v7H4a1 1 0 0 1-1-1V10z"/></svg></div>
      <div style="margin-top:6px">Home</div>
    </div>
    <div class="nav-item" onclick="location.href='earn.php'">
      <div class="icon"><div style="width:24px;height:24px;background:linear-gradient(180deg,#1fbf9a,#16826f);border-radius:50%;display:flex;align-items:center;justify-content:center;font-weight:700;color:#fff">T</div></div>
      <div style="margin-top:6px">Earn</div>
    </div>
    <div class="nav-item active" onclick="location.href='invest.php'">
      <div class="icon"><svg viewBox="0 0 24 24"><path d="M12 2C8.13 2 5 5.13 5 9c0 5.25 7 13 7 13s7-7.75 7-13c0-3.87-3.13-7-7-7z"/></svg></div>
      <div style="margin-top:6px">Invest</div>
    </div>
    <div class="nav-item" onclick="location.href='team.php'">
      <div class="icon"><svg viewBox="0 0 24 24"><path d="M16 11c1.66 0 2.99-1.34 2.99-3S17.66 5 16 5s-3 1.34-3 3 1.34 3 3 3zM8 11c1.66 0 2.99-1.34 2.99-3S9.66 5 8 5 5 6.34 5 8s1.34 3 3 3zm0 2c-2.33 0-7 1.17-7 3.5V19h14v-2.5C15 14.17 10.33 13 8 13zm8 0c-.29 0-.62.02-.97.05 1.16.84 1.97 1.97 1.97 3.45V19h6v-2.5c0-2.33-4.67-3.5-7-3.5z"/></svg></div>
      <div style="margin-top:6px">Team</div>
    </div>
    <div class="nav-item" onclick="location.href='profile.php'">
      <div class="icon"><svg viewBox="0 0 24 24"><path d="M12 12c2.7 0 5-2.3 5-5s-2.3-5-5-5-5 2.3-5 5 2.3 5 5 5zm0 2c-3.3 0-10 1.7-10 5v3h20v-3c0-3.3-6.7-5-10-5z"/></svg></div>
      <div style="margin-top:6px">Profile</div>
    </div>
  </div>
</body>
</html>
