<?php
session_start();
require_once "db.php"; // connection kwa database

// check kama user ame-login
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

$user_id = $_SESSION['user_id'];

// fetch details za user kutoka users table
$stmt = $conn->prepare("SELECT username, phone, balance FROM users WHERE id=? LIMIT 1");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$stmt->bind_result($username, $phone, $balance);
$stmt->fetch();
$stmt->close();
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Smart360 - Profile</title>
  <style>
    @import url('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;600;700;800&display=swap');
    :root{
      --bg1:#1ca68f;
      --bg2:#2aa78d;
      --accent:#1fbf9a;
      --accent-dark:#16826f;
    }
    *{margin:0;padding:0;box-sizing:border-box}
    body{
      font-family:Inter,system-ui;
      background:linear-gradient(180deg,var(--bg1),var(--bg2));
      display:flex;justify-content:center;
      padding:24px 12px;
      color:#fff;
    }
    .phone{
      width:390px;min-height:780px;
      background:rgba(255,255,255,0.02);
      border-radius:28px;
      padding:18px 16px 98px;
      box-shadow:0 18px 40px rgba(5,40,35,0.45);
      position:relative;
    }
    h1{text-align:center;font-size:22px;margin-bottom:20px;font-weight:700}
    
    .profile-header{
      text-align:center;
      margin-bottom:22px;
    }
    .avatar{
      width:56px;height:56px;border-radius:50%;
      margin:0 auto 12px;
      border:3px solid var(--accent);
      background:#fff url('https://cdn-icons-png.flaticon.com/512/149/149071.png') center/cover no-repeat;
    }
    .name{font-size:18px;font-weight:700;margin-bottom:4px}
    .email{font-size:14px;color:#d2f4ee}

    .balance-card{
      background:rgba(0,0,0,0.25);
      padding:16px;
      border-radius:16px;
      text-align:center;
      margin-bottom:22px;
    }
    .balance-card h2{font-size:14px;font-weight:500;color:#dffaf4;margin-bottom:6px}
    .balance-card .amount{font-size:22px;font-weight:800;color:var(--accent)}

    .actions{
      display:grid;
      grid-template-columns:1fr 1fr;
      gap:14px;
      margin-bottom:24px;
    }
    .btn{
      padding:12px;
      border-radius:12px;
      font-size:14px;
      font-weight:600;
      border:none;
      cursor:pointer;
      text-align:center;
    }
    .btn-primary{background:linear-gradient(180deg,var(--accent),var(--accent-dark));color:#fff}
    .btn-outline{background:transparent;border:1.5px solid var(--accent);color:var(--accent)}

    .list{
      background:rgba(0,0,0,0.25);
      border-radius:14px;
      overflow:hidden;
    }
    .list-item{
      display:flex;align-items:center;
      padding:14px 16px;
      border-bottom:1px solid rgba(255,255,255,0.08);
      cursor:pointer;
    }
    .list-item:last-child{border-bottom:none}
    .list-item svg{width:20px;height:20px;fill:var(--accent);margin-right:12px}
    .list-item span{font-size:14px;font-weight:500;color:#fff}

    /* bottom nav */
    .bottom-nav{
      position:fixed;left:50%;transform:translateX(-50%);
      bottom:12px;width:calc(100% - 36px);max-width:366px;
      background:linear-gradient(180deg,rgba(0,0,0,0.02),rgba(0,0,0,0.03));
      backdrop-filter:blur(6px);
      border-radius:14px;padding:10px 12px;
      display:flex;align-items:center;justify-content:space-around;
    }
    .nav-item{flex:1;display:flex;flex-direction:column;align-items:center;padding:8px 6px;border-radius:10px;color:#dffaf4;font-size:13px;cursor:pointer}
    .nav-item .icon{width:44px;height:44px;border-radius:10px;display:flex;align-items:center;justify-content:center;background:rgba(255,255,255,0.02)}
    .nav-item.active{background:linear-gradient(180deg,rgba(0,0,0,0.07),rgba(0,0,0,0.03))}
    .nav-item svg{width:22px;height:22px;fill:#dffaf4}
    .nav-item.active svg{fill:var(--accent)}
  </style>
</head>
<body>
  <div class="phone">
    <h1>Smart360</h1>

    <!-- Profile Info -->
    <div class="profile-header">
      <div class="avatar"></div>
      <div class="name"><?= htmlspecialchars($username) ?></div>
      <div class="email"><?= htmlspecialchars($phone) ?></div>
    </div>

    <!-- Balance -->
    <div class="balance-card">
      <h2>Available Balance</h2>
      <div class="amount"><?= number_format($balance, 2) ?> USDT</div>
    </div>

    <!-- Actions -->
    <div class="actions">
      <button class="btn btn-primary" onclick="location.href='withdraw.php'">Withdraw</button>
      <button class="btn btn-outline" onclick="location.href='recharge_usdt.php'">Deposit</button>
      <button class="btn btn-outline" onclick="location.href='assets.php'">System Tutorials</button>
      <button class="btn btn-outline" onclick="location.href='#'">Security</button>
    </div>

    <!-- Settings -->
    <div class="list">
      <div class="list-item" onclick="location.href='edit.php'"><svg viewBox="0 0 24 24"><path d="M12 12c2.7 0 5-2.3 5-5s-2.3-5-5-5-5 2.3-5 5 2.3 5 5 5zm0 2c-3.3 0-10 1.7-10 5v3h20v-3c0-3.3-6.7-5-10-5z"/></svg><span>Edit Profile</span></div>
      <div class="list-item" onclick="location.href='history.php'"><svg viewBox="0 0 24 24"><path d="M12 2L2 7v13h20V7L12 2zm0 2.18L18.82 7H5.18L12 4.18zM20 18H4V9h16v9z"/></svg><span>Transaction History</span></div>
      <div class="list-item" onclick="location.href='support.php'"><svg viewBox="0 0 24 24"><path d="M12 22c5.5 0 10-4.5 10-10S17.5 2 12 2 2 6.5 2 12s4.5 10 10 10zm-1-5v-2h2v2h-2zm0-4V6h2v7h-2z"/></svg><span>Help & Support</span></div>
      <div class="list-item" onclick="location.href='team.php'"><svg viewBox="0 0 24 24"><path d="M16 13v-2h-4V7h-2v4H6v2h4v4h2v-4h4z"/></svg><span>Invite Friends</span></div>
      <div class="list-item" onclick="location.href='login.php'"><svg viewBox="0 0 24 24"><path d="M16 13H7.83l5.59 5.59L12 20l-8-8 8-8 1.41 1.41L7.83 11H16v2z"/></svg><span>Logout</span></div>
    </div>
  </div>

  <!-- Bottom Navigation -->
  <div class="bottom-nav">
    <div class="nav-item" onclick="location.href='home.php'">
      <div class="icon"><svg viewBox="0 0 24 24"><path d="M3 10L12 3l9 7v11a1 1 0 0 1-1 1h-6v-7h-4v7H4a1 1 0 0 1-1-1V10z"/></svg></div>
      <div style="margin-top:6px">Home</div>
    </div>
    <div class="nav-item" onclick="location.href='earn.php'">
      <div class="icon"><div style="width:24px;height:24px;background:linear-gradient(180deg,#1fbf9a,#16826f);border-radius:50%;display:flex;align-items:center;justify-content:center;font-weight:700;color:#fff">T</div></div>
      <div style="margin-top:6px">Earn</div>
    </div>
    <div class="nav-item" onclick="location.href='invest.php'">
      <div class="icon"><svg viewBox="0 0 24 24"><path d="M12 2C8.13 2 5 5.13 5 9c0 5.25 7 13 7 13s7-7.75 7-13c0-3.87-3.13-7-7-7z"/></svg></div>
      <div style="margin-top:6px">Invest</div>
    </div>
    <div class="nav-item" onclick="location.href='team.php'">
      <div class="icon"><svg viewBox="0 0 24 24"><path d="M16 11c1.66 0 2.99-1.34 2.99-3S17.66 5 16 5s-3 1.34-3 3 1.34 3 3 3zM8 11c1.66 0 2.99-1.34 2.99-3S9.66 5 8 5 5 6.34 5 8s1.34 3 3 3zm0 2c-2.33 0-7 1.17-7 3.5V19h14v-2.5C15 14.17 10.33 13 8 13zm8 0c-.29 0-.62.02-.97.05 1.16.84 1.97 1.97 1.97 3.45V19h6v-2.5c0-2.33-4.67-3.5-7-3.5z"/></svg></div>
      <div style="margin-top:6px">Team</div>
    </div>
    <div class="nav-item active" onclick="location.href='profile.php'">
      <div class="icon"><svg viewBox="0 0 24 24"><path d="M12 12c2.7 0 5-2.3 5-5s-2.3-5-5-5-5 2.3-5 5 2.3 5 5 5zm0 2c-3.3 0-10 1.7-10 5v3h20v-3c0-3.3-6.7-5-10-5z"/></svg></div>
      <div style="margin-top:6px">Profile</div>
    </div>
  </div>
</body>
</html>
