<?php
session_start();
require_once "db.php"; // hakikisha una db.php yenye $conn = new mysqli(...)

// function ya kutengeneza referral code ya kipekee
function generateReferralCode($length = 8){
    $chars = 'ABCDEFGHJKLMNPQRSTUVWXYZ23456789';
    $code = '';
    for($i=0; $i<$length; $i++){
        $code .= $chars[random_int(0, strlen($chars)-1)];
    }
    return $code;
}

$errors = [];
$success = "";

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $username = trim($_POST["username"] ?? '');
    $phone    = trim($_POST["phone"] ?? '');
    $password = $_POST["password"] ?? '';
    $confirm  = $_POST["confirmPassword"] ?? '';
    $refCode  = trim($_POST["referral"] ?? '');

    if ($username === "" || $phone === "" || $password === "" || $confirm === "") {
        $errors[] = "All fields are required.";
    }
    if ($password !== $confirm) {
        $errors[] = "Passwords do not match.";
    }
    if (strlen($password) < 6) {
        $errors[] = "Password must be at least 6 characters.";
    }

    if (empty($errors)) {
        $stmt = $conn->prepare("SELECT id FROM users WHERE phone=?");
        $stmt->bind_param("s", $phone);
        $stmt->execute();
        $stmt->store_result();
        if ($stmt->num_rows > 0) {
            $errors[] = "Phone number already registered.";
        }
        $stmt->close();
    }

    if (empty($errors)) {
        $hashed = password_hash($password, PASSWORD_BCRYPT);
        $myCode = generateReferralCode();
        $referredBy = null;

        if ($refCode !== "") {
            // hapa sasa tunapata id ya aliye tumia referral
            $stmt = $conn->prepare("SELECT id FROM users WHERE referral_code=? LIMIT 1");
            $stmt->bind_param("s", $refCode);
            $stmt->execute();
            $stmt->bind_result($refId);
            if ($stmt->fetch()) {
                $referredBy = $refId; // hifadhi id badala ya referral_code
            }
            $stmt->close();
        }

        $stmt = $conn->prepare("INSERT INTO users (username, phone, password, referral_code, referred_by, balance) VALUES (?,?,?,?,?,0.00)");
        $stmt->bind_param("ssssi", $username, $phone, $hashed, $myCode, $referredBy);
        if ($stmt->execute()) {
            $success = "Account created successfully!";
        } else {
            $errors[] = "Database error: ".$stmt->error;
        }
        $stmt->close();
    }
}
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width,initial-scale=1" />
  <title>Register - Smart360</title>
  <style>
    @import url('https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap');
    :root{--bg1:#1ca68f;--bg2:#2aa78d;--accent:#1fbf9a;--accent-dark:#16826f;--panel:rgba(0,0,0,0.5);}
    *{box-sizing:border-box;margin:0;padding:0}
    body{font-family:Inter,system-ui,Segoe UI,Roboto,Arial;background:linear-gradient(180deg,var(--bg1),var(--bg2));min-height:100vh;display:flex;align-items:center;justify-content:center;padding:20px;color:#fff;flex-direction:column;}
    .logo{font-size:28px;font-weight:800;margin-bottom:20px;letter-spacing:1px;background:linear-gradient(90deg,#fff,var(--accent));-webkit-background-clip:text;-webkit-text-fill-color:transparent;text-align:center;text-shadow:0 2px 6px rgba(0,0,0,0.4);}
    .register-box{width:390px;background:rgba(255,255,255,0.05);border-radius:18px;padding:20px;box-shadow:0 10px 30px rgba(0,0,0,0.35);}
    h1{font-size:20px;text-align:center;margin-bottom:14px}
    .form-group{margin-bottom:14px}
    label{display:block;margin-bottom:6px;font-weight:600;font-size:13px}
    input[type="text"],input[type="password"],input[type="tel"]{width:100%;padding:12px;border-radius:10px;border:none;background:rgba(255,255,255,0.03);color:#fff;font-size:15px;outline:none;}
    .phone-row{display:flex;gap:10px;align-items:center}
    .cc-btn{flex:0 0 66px;padding:10px 13px;border-radius:10px;border:none;background:rgba(0,0,0,0.25);color:#fff;font-weight:700;font-size:15px;cursor:pointer;display:flex;align-items:center;justify-content:space-between;}
    .cc-btn .arrow{font-size:12px;opacity:0.9}
    .phone-row .phone-input{flex:1;}
    .picker{position:absolute;left:0;right:0;top:100%;margin-top:10px;background:var(--panel);border-radius:12px;padding:8px;box-shadow:0 10px 30px rgba(0,0,0,0.5);max-height:320px;overflow:hidden;display:none;z-index:50;}
    .picker.open{display:block}
    .picker .search{width:100%;padding:10px;border-radius:8px;border:none;margin-bottom:8px;background:rgba(255,255,255,0.03);color:#fff}
    .country-list{max-height:250px;overflow:auto}
    .country-item{display:flex;align-items:center;justify-content:space-between;padding:8px;border-radius:8px;cursor:pointer;gap:10px;font-size:14px;color:#fff;}
    .country-item:hover{background:rgba(255,255,255,0.03)}
    .country-left{display:flex;align-items:center;gap:10px}
    .flag{font-size:18px}
    .country-name{white-space:nowrap;overflow:hidden;text-overflow:ellipsis;max-width:220px}
    .muted{color:rgba(255,255,255,0.7);font-size:13px}
    button[type="submit"]{width:100%;padding:12px;border-radius:10px;border:none;background:linear-gradient(180deg,var(--accent),var(--accent-dark));color:#04251f;font-weight:700;font-size:15px;margin-top:6px;cursor:pointer;}
    .login-link{text-align:center;margin-top:14px;font-size:13px;}
    .login-link a{color:#fff;font-weight:600;text-decoration:none;}
    .login-link a:hover{text-decoration:underline;}
    .alert{padding:10px;border-radius:8px;margin-bottom:10px;font-size:14px}
    .alert.error{background:#ff6b6b;color:#fff}

    /* Popup overlay */
    .overlay{position:fixed;top:0;left:0;width:100%;height:100%;background:transparent;display:flex;align-items:center;justify-content:center;z-index:999;display:none;}
    .popup{background:transparent;color:#222;padding:30px 25px;border-radius:12px;text-align:center;width:300px;box-shadow:0 8px 30px rgba(0,0,0,0.5);}
    .spinner{border:4px solid #ddd;border-top:4px solid #000;border-radius:50%;width:50px;height:50px;margin:0 auto 15px;animation:spin 1s linear infinite;}
    @keyframes spin{100%{transform:rotate(360deg)}}
    .popup h2{margin-top:10px;font-size:18px}
  </style>
</head>
<body>
  <div class="logo">Smart360</div>
  <div class="register-box">
    <h1>Create account</h1>

    <?php if(!empty($errors)): ?>
      <div class="alert error">
        <?php foreach($errors as $e) echo htmlspecialchars($e)."<br>"; ?>
      </div>
    <?php endif; ?>

    <form id="regForm" method="post" autocomplete="on" <?= $success ? 'style="display:none;"' : '' ?>>
      <div class="form-group">
        <label for="username">Username</label>
        <input id="username" name="username" type="text" placeholder="Enter username" required />
      </div>

      <div class="form-group">
        <label for="phone">Phone number</label>
        <div style="position:relative" class="phone-row">
          <button type="button" id="ccBtn" class="cc-btn"><span id="ccDisplay">+1</span> <span class="arrow">▾</span></button>
          <div style="flex:1;position:relative">
            <input id="phone" name="phone" type="tel" placeholder="Phone number" required />
            <div id="picker" class="picker">
              <input id="pickerSearch" class="search" placeholder="Search country or code" />
              <div class="country-list" id="countryList"><div style="padding:10px" class="muted">Loading…</div></div>
            </div>
          </div>
        </div>
      </div>

      <div class="form-group">
        <label for="password">Password</label>
        <input id="password" name="password" type="password" placeholder="Enter password" required />
      </div>
      <div class="form-group">
        <label for="confirmPassword">Confirm password</label>
        <input id="confirmPassword" name="confirmPassword" type="password" placeholder="Confirm password" required />
      </div>
      <div class="form-group">
        <label for="referral">Referral Code (optional)</label>
        <input id="referral" name="referral" type="text" placeholder="Enter referral code" />
      </div>
      <button type="submit">Register</button>
    </form>

    <div class="login-link">Already have an account? <a href="login.php">Login</a></div>
  </div>

  <!-- Popup overlay -->
  <div id="overlay" class="overlay">
    <div class="popup">
      <div id="popupSpinner" class="spinner"></div>
      <h2 id="popupText">.</h2>
    </div>
  </div>

<script>
function getFlagEmoji(iso2){if(!iso2) return '';try{const codePoints=iso2.toUpperCase().split('').map(c=>127397+c.charCodeAt(0));return String.fromCodePoint(...codePoints);}catch(e){return ''}}
function normalizeDial(root,suffixes){if(!root) return '';if(!suffixes||suffixes.length===0) return root;let s=suffixes[0]||'';return root+s;}
const ccBtn=document.getElementById('ccBtn');const ccDisplay=document.getElementById('ccDisplay');const picker=document.getElementById('picker');const pickerSearch=document.getElementById('pickerSearch');const countryListEl=document.getElementById('countryList');const phoneInput=document.getElementById('phone');
let countries=[];let selectedDial='+1';ccDisplay.textContent=selectedDial;
const FALLBACK=[{name:"United States",iso2:"US",dial:"+1"},{name:"Kenya",iso2:"KE",dial:"+254"},{name:"United Kingdom",iso2:"GB",dial:"+44"},{name:"India",iso2:"IN",dial:"+91"},{name:"Nigeria",iso2:"NG",dial:"+234"}];
async function loadCountries(){try{const res=await fetch('https://restcountries.com/v3.1/all?fields=name,cca2,idd');if(!res.ok) throw new Error('network');const data=await res.json();const list=data.map(c=>{const name=(c.name&&(c.name.common||c.name.official))||c.name||'';const iso2=c.cca2||'';const dial=(c.idd)?normalizeDial(c.idd.root,c.idd.suffixes):'';return {name,iso2,dial};}).filter(c=>c.dial&&c.name).sort((a,b)=>a.name.localeCompare(b.name));if(list.length===0) throw new Error('empty');countries=list;}catch(err){countries=FALLBACK;}renderCountryList(countries);}
function renderCountryList(list){countryListEl.innerHTML='';if(!list||list.length===0){countryListEl.innerHTML='<div style="padding:10px" class="muted">No countries</div>';return;}const fragment=document.createDocumentFragment();list.forEach(c=>{const item=document.createElement('div');item.className='country-item';item.tabIndex=0;item.dataset.dial=c.dial;const left=document.createElement('div');left.className='country-left';const flag=document.createElement('div');flag.className='flag';flag.textContent=getFlagEmoji(c.iso2);const nameEl=document.createElement('div');nameEl.className='country-name';nameEl.textContent=c.name;left.appendChild(flag);left.appendChild(nameEl);const right=document.createElement('div');right.className='muted';right.style.minWidth='70px';right.style.textAlign='right';right.textContent=c.dial;item.appendChild(left);item.appendChild(right);item.addEventListener('click',()=>selectCountry(c));fragment.appendChild(item);});countryListEl.appendChild(fragment);}
function selectCountry(c){selectedDial=c.dial;ccDisplay.textContent=selectedDial;closePicker();phoneInput.focus();}
function togglePicker(){const open=picker.classList.toggle('open');if(open){pickerSearch.value='';renderCountryList(countries);setTimeout(()=>pickerSearch.focus(),50);}}
function closePicker(){picker.classList.remove('open');}
ccBtn.addEventListener('click',e=>{e.stopPropagation();togglePicker();});
pickerSearch.addEventListener('input',()=>{const q=pickerSearch.value.trim().toLowerCase();if(!q){renderCountryList(countries);return;}const filtered=countries.filter(c=>c.name.toLowerCase().includes(q)||(c.dial&&c.dial.includes(q))||(c.iso2&&c.iso2.toLowerCase()===q.toLowerCase()));renderCountryList(filtered);});
document.addEventListener('click',e=>{if(!picker.contains(e.target)&&!ccBtn.contains(e.target)) closePicker();});
document.addEventListener('keydown',e=>{if(e.key==='Escape') closePicker();});
document.getElementById('regForm').addEventListener('submit',()=>{const fullPhone=(selectedDial||'')+phoneInput.value.replace(/^\+/,'');document.getElementById('phone').value=fullPhone;});

// Handle success popup
<?php if($success): ?>
  const overlay=document.getElementById('overlay');
  const popupSpinner=document.getElementById('popupSpinner');
  const popupText=document.getElementById('popupText');
  overlay.style.display='flex';
  popupSpinner.style.display='block';
  popupText.textContent="Processing...";
  setTimeout(()=>{
    popupSpinner.style.display='none';
    popupText.textContent="Success!";
    setTimeout(()=>{window.location.href="home.php";},2000);
  },2000);
<?php endif; ?>

loadCountries();
</script>
</body>
</html>
